/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.autocomplete;

import club.sk1er.mods.autocomplete.AutocompleteConfigGUI;
import club.sk1er.mods.autocomplete.AutocompleteImpl;
import club.sk1er.mods.autocomplete.CommandAutocomplete;
import club.sk1er.mods.autocomplete.Multithreading;
import club.sk1er.mods.autocomplete.config.MasterConfig;
import club.sk1er.mods.autocomplete.sources.AutocompleteSources;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

@Mod(modid="hypixel_auto_complete", version="1.0", acceptedMinecraftVersions="[1.8.9]")
public class AutocompleteMod {
    public static final String MODID = "hypixel_auto_complete";
    public static final String VERSION = "1.0";
    public static AutocompleteMod instance;
    public boolean display;
    private MasterConfig masterConfig;
    private boolean hypixel;
    private Set<String> registeredCommands = new HashSet<String>();

    public AutocompleteMod() {
        instance = this;
    }

    @Mod.EventHandler
    public void init(FMLPreInitializationEvent event) {
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandAutocomplete());
        this.masterConfig = new MasterConfig(event.getSuggestedConfigurationFile());
        Multithreading.runAsync(() -> {
            for (AutocompleteSources value : AutocompleteSources.values()) {
                value.refresh();
            }
        });
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void ensure(String name, AutocompleteSources ... sources) {
        if (this.registeredCommands.add(name)) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new AutocompleteImpl(name, sources));
        }
    }

    public void delete(String name) {
        ICommand remove = (ICommand)ClientCommandHandler.instance.field_71562_a.remove(name);
        if (remove == null) {
            return;
        }
        ClientCommandHandler.instance.field_71561_b.remove(remove);
    }

    @SubscribeEvent
    public void onLoin(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        boolean bl = this.hypixel = !FMLClientHandler.instance().getClient().func_71356_B() && (FMLClientHandler.instance().getClient().func_147104_D().field_78845_b.contains("hypixel.net") || FMLClientHandler.instance().getClient().func_147104_D().field_78847_a.equalsIgnoreCase("HYPIXEL"));
        if (this.hypixel) {
            HashMap<String, Integer> commands = this.masterConfig.getCommands();
            for (String s : commands.keySet()) {
                this.ensure(s, AutocompleteSources.values());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogOutEvent(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        try {
            this.hypixel = false;
            for (String registeredCommand : this.registeredCommands) {
                this.delete(registeredCommand);
            }
            this.registeredCommands.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent e) {
        if (this.display) {
            this.display = false;
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new AutocompleteConfigGUI());
        }
    }

    public MasterConfig getMasterConfig() {
        return this.masterConfig;
    }
}

